<?php
/**
 * @package     Joomla.Site
 * @subpackage  Templates.protostar
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
$app             = JFactory::getApplication();
$doc             = JFactory::getDocument();
$user            = JFactory::getUser();
$this->language  = $doc->language;
$this->direction = $doc->direction;
// Getting params from template
$params = $app->getTemplate(true)->params;
// Detecting Active Variables
$option   = $app->input->getCmd('option', '');
$view     = $app->input->getCmd('view', '');
$layout   = $app->input->getCmd('layout', '');
$task     = $app->input->getCmd('task', '');
$itemid   = $app->input->getCmd('Itemid', '');
$sitename = $app->get('sitename');
if($task == "edit" || $layout == "form" )
{
	$fullWidth = 1;
}
else
{
	$fullWidth = 0;
}
// Add JavaScript Frameworks
JHtml::_('bootstrap.framework');
$doc->addScript($this->baseurl . '/templates/' . $this->template . '/js/custom.js');
$doc->addScript($this->baseurl . '/templates/' . $this->template . '/js/bootstrap.js');
$doc->addScript($this->baseurl . '/templates/' . $this->template . '/js/bootstrap.min.js');

// Add Stylesheets
$doc->addStyleSheet($this->baseurl . '/templates/' . $this->template . '/css/bootstrap.css');
$doc->addStyleSheet($this->baseurl . '/templates/' . $this->template . '/css/bootstrap.min.css');
$doc->addStyleSheet($this->baseurl . '/templates/' . $this->template . '/css/style.css');
$doc->addStyleSheet($this->baseurl . '/templates/' . $this->template . '/css/font-awesome-4.2.0/css/font-awesome.min.css');
// Load optional RTL Bootstrap CSS
JHtml::_('bootstrap.loadCss', false, $this->direction);
// Adjusting content width
if ($this->countModules('position-7') && $this->countModules('position-8'))
{
	$span = "span6";
}
elseif ($this->countModules('position-7') && !$this->countModules('position-8'))
{
	$span = "span9";
}
elseif (!$this->countModules('position-7') && $this->countModules('position-8'))
{
	$span = "span9";
}
else
{
	$span = "span12";
}
// Logo file or site title param
if ($this->params->get('logoFile'))
{
	$logo = '<img src="' . JUri::root() . $this->params->get('logoFile') . '" alt="' . $sitename . '" />';
}
elseif ($this->params->get('sitetitle'))
{
	$logo = '<span class="site-title" title="' . $sitename . '">' . htmlspecialchars($this->params->get('sitetitle')) . '</span>';
}
else
{
	$logo = '<span class="site-title" title="' . $sitename . '">' . $sitename . '</span>';
}

?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $this->language; ?>" lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<jdoc:include type="head" />
<?php // Template color ?>
<?php if ($this->params->get('templateColor')) : ?>
<?php endif; ?>
<!--[if lt IE 9]>

		<script src="<?php echo JUri::root(true); ?>/media/jui/js/html5.js"></script>

	<![endif]-->
<?php 
$active = JFactory::getApplication()->getMenu()->getActive();
?>
<?php $this->setGenerator(null); ?>
<script src="https://kit.fontawesome.com/bcf6a149fb.js" crossorigin="anonymous"></script>
</head>
<!-- oncontextmenu="return false" onmousedown="return false" -->
<body data-target=".navbar-fixed-top" class="site <?php echo $option

	. ($itemid ? ' itemid-' . $itemid : '');

?>">
<div id="preloader">
	<div class="preloader-fountainTextG">
      <div id="fountainTextG_1" class="fountainTextG">L</div>
      <div id="fountainTextG_2" class="fountainTextG">o</div>
      <div id="fountainTextG_3" class="fountainTextG">a</div>
      <div id="fountainTextG_4" class="fountainTextG">d</div>
      <div id="fountainTextG_5" class="fountainTextG">i</div>
      <div id="fountainTextG_6" class="fountainTextG">n</div>
      <div id="fountainTextG_7" class="fountainTextG">g</div>
    </div>
</div>
<div class="main-header">
	<div class="top-info">
		<div class="container">	
			<div class="row">
			<div class="col-md-6 styled-icons">
				<jdoc:include type="modules" name="social" style="none" />
			</div>
			<div class="col-md-6 search">
				<jdoc:include type="modules" name="top-search" style="none" />
			</div>
			</div>
		</div>
	</div>
	<div class="container">
		<div class="row row-button">
			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-main-collapse">
				<i class="fa fa-bars"></i>
			</button>
			<div class="col-md-3 logo">			
				<jdoc:include type="modules" name="place1" style="none" />
			</div>
			<div class="col-md-9 item-info">
				<jdoc:include type="modules" name="place2" style="none" />
			</div>
		</div>		
	</div>
	<div class="top-menu">
		<div class="container">
			<div class="collapse navbar-collapse navbar-main-collapse">
				<jdoc:include type="modules" name="place3" style="none" />
			</div>
		</div>
	</div>
</div>

<div class="place4">
	<jdoc:include type="modules" name="place4" style="none" />
</div>

<div class="breadcrumbs">
	<div class="container">
		<jdoc:include type="modules" name="user1" style="none" />
	</div>
</div>

<div class="main_content">
	<div class="container">
		<div class="content">
			<jdoc:include type="component" />
			<div class="clearfix"></div>
		</div>
	</div>
</div>

<div class="place5">
	<div class="container">
		<jdoc:include type="modules" name="place5" style="well" />
	</div>
</div>

<div class="place6">
	<div class="container">
		<div class="row">
			<jdoc:include type="modules" name="user2" style="well" />
			<jdoc:include type="modules" name="place6" style="none" />
		</div>
	</div>
</div>

<div class="place7">
	<div class="container">
		<div class="row">
			<jdoc:include type="modules" name="user3" style="well" />
			<jdoc:include type="modules" name="place7" style="none" />
		</div>
	</div>	
</div>

<div class="place8">
	<div class="container">
		<div class="row">
	        <jdoc:include type="modules" name="user4" style="well" />
	        <jdoc:include type="modules" name="place8" style="well" />
		</div>
	</div>
</div>

<div class="footer-wrapper">
	<div class="container">
        <div class="row">
        	<div class="col-md-4 place11">
        		<jdoc:include type="modules" name="box-1" style="well" />
            	<jdoc:include type="modules" name="place11" style="well" />
            </div>
            <div class="col-md-4 place12">
            	<jdoc:include type="modules" name="box-2" style="well" />
            	<jdoc:include type="modules" name="place12" style="well" />           	
            </div>
            <div class="col-md-4 place13">
            	<jdoc:include type="modules" name="box-3" style="well" />
            	<jdoc:include type="modules" name="place13" style="well" />           	
            </div>
        </div>
	</div>
	<div class="place14">
		<div class="container">
			<jdoc:include type="modules" name="place14" style="well" />
		</div>
	</div>
</div>

</body>
</html>
